<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório Movimentação de Estoque</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.19.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.2511.19.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.2511.19.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.2511.19.1" />
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.2511.19.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.2511.19.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
</head>

<style>
  .table.dataTable tbody td {
    white-space: nowrap;
    text-overflow: ellipsis;
    overflow: hidden;
  }
</style>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <?php
    include_once('../../menu.php');
    ?>

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-8 flex">
              <h1 class="m-0 text-dark">Relatório de Movimentação de Estoque</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-4">
              <!-- <ol class="breadcrumb float-sm-right">
                
                <li class="breadcrumb-item active">Relatório de Movimentação de Estoque</li>
              </ol> -->
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row">
                  <div class="col-12">
                    <div class="buttons">
                      <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                      <button id="btnImprimir" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
                <div class="card-body">
                  <div class="card">
                    <div class="col-sm-12 table-responsive card-body">
                      <table id="tabelaRelMovimentacao" class="table table-sm table-select table-hover" width="100%"></table>
                      <thead>
                        <tr></tr>
                      </thead>
                      <tbody>
                        <tr></tr>
                      </tbody>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header">
            <h4 class="modal-title">Filtros
              <label style="font-size: 60%" class="container escondeRadio">Todos 
                <input type="radio" checked="checked" id="radioTodos" name="tipoFat">
                <span class="checkmark"></span>
              </label>
              <label style="font-size: 60%; margin-left: -2.5%" class="container escondeRadio">Entrada
                <input type="radio" id="radioEntrada" name="tipoFat">
                <span class="checkmark"></span>
              </label>
              <label style="font-size: 60%; margin-left: -2.5%" class="container escondeRadio">Saída
                <input type="radio" id="radioSaida" name="tipoFat">
                <span class="checkmark"></span>
              </label>
            </h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <div class="row">
              <div class="col-lg-2 col-sm-2 col-12 form-group">
                <div class="group-default">
                  <label for="txtDataDe">Data De:</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataDe" name="txtDataDe">
                  </div>
                </div>
              </div>
              <div class="col-lg-2 col-sm-2 col-12 form-group">
                <div class="group-default">
                  <label for="txtDataAte">Data Até:</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataAte" name="txtDataAte">
                  </div>
                </div>
              </div>
              <div class="col-lg-10 col-sm-10 col-12"></div>

              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" id="labelProduto" for="txtProduto">Produto: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtCor">Cor: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtCor" name="txtCor" class="form-control" placeholder="Cor"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtCor" name="txtCor" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCor" name="btn-Cor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtTamanho">Tamanho: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtTamanho" name="txtTamanho" class="form-control" placeholder="Tamanho"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtTamanho" name="txtTamanho" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnTamanho" name="btn-Tamanho" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaTamanho" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtDepositoUsuario">Depósito: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtDepositoUsuario" name="txtDepositoUsuario" class="form-control" placeholder="DepositoUsuario"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtDepositoUsuario" name="txtDepositoUsuario" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnDepositoUsuario" name="btnDepositoUsuario" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaDepositoUsuario" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtTipoMov">Tipo de Movimentação: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtTipoMov" name="txtTipoMov" class="form-control" placeholder="Tipo de movimentação"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtTipoMov" name="txtVendedor" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnTipoMov" name="btn-TipoMov" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaTipoMov" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtQualidade">Qualidade: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtQualidade" name="txtQualidade" class="form-control" placeholder="Qualidade"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtQualidade" name="txtQualidade" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnQualidade" name="btnQualidade" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaQualidade" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtGrupo">Grupo: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtGrupo" name="txtGrupo" class="form-control" placeholder="Grupo"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtGrupo" name="txtGrupo" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtEtiqueta" name="txtEtiqueta" class="form-control" placeholder="Etiqueta"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtEtiqueta" name="txtEtiqueta" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnEtiqueta" name="btnEtiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaEtiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtLinha">Linha: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtLinha" name="txtLinha" class="form-control" placeholder="Linha"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtLinha" name="txtLinha" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnLinha" name="btnLinha" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaLinha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtColecao">Coleção: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtColecao" name="txtColecao" class="form-control" placeholder="Colecao"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnColecao" name="btnColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtMarca">Marca: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtMarca" name="txtMarca" class="form-control" placeholder="Marca"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtMarca" name="txtMarca" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMarca" name="btnMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtModelo">Modelo: </label>
                <div class="relative">
                  <div class="input-group">
                    <!-- <input type="text" class="input-default focus form-control" id="txtModelo" name="txtModelo" class="form-control" placeholder="Modelo"> -->
                    <select class="js-example-programmatic js-states form-control" id="txtModelo" name="txtModelo" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnModelo" name="btnModelo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaModelo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-lg-6 col-sm-6 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtDocto">Lista de Documentos: </label>
                <div class="relative">
                  <div class="input-group">
                    <input type="text" class="input-default col-lg-3 col-12 focus form-control" id="txtDocto" name="txtDocto" class="form-control" placeholder="Docto">
                    <input type="text" id="txtListaDocto" class="form-group col-lg-9 col-12 input-default focus form-control" placeholder="Lista de Documentos" disabled>
                    <button class="btn bg-danger" id="btn-limpa-Docto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>
              <div class="col-lg-6 col-sm-6 col-12 form-group">
                <label data-error="wrong" data-success="right" for="txtObs">Observação: </label>
                <div class="relative">
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtObs" name="txtObs" class="form-control" placeholder="Observação">
                  </div>
                </div>
              </div>
              <!-- <div class="col-lg-4 col-sm-4 col-12 form-group">
                <label data-error="wrong" class="labelGearal" data-success="right" for="txtOrdem">Opção de Relatório: </label>
                <div class="input-group">
                  <select class="input-default focus form-control" data-dropdown-css-class="select2-danger" id="txtOrdem" class="custom-select">
                  </select>
                </div>
              </div> -->
            </div>
          </div>
          <div class="modal-footer">
            <div class="form-row col-12 m-0 p-0">
              <div class="col-md-4 col-sm-4 col-12">
                <label for="txtOrdem">Opção de Relatório:</label>
                <div class="relative d-flex align-items-center">
                  <select id="txtOrdem" class="input-default focus custom-select">
                  </select>
                  <button class="btn btn-sm btn-success ml-2 btnEdicaoRelatorio" title="Edição de ordenações">
                    <i class="fas fa-check"></i>
                  </button>
                </div>
              </div>
              <div class="col-md-8 col-sm-8 col-12 d-flex justify-content-end align-items-end pr-0">
                <div class="d-flex">
                  <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222">
                    <span class="fas fa-trash"></span> Limpar Filtros
                  </button>
                  <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                    <span class="fas fa-search"></span> Consultar
                  </button>
                </div>
              </div>
            </div>
          </div>
          <!-- <div class="modal-footer">
            <div class="row">
              <button id="btnConsultar" class='btn btn-primary btn-sisp' type='button'><span class="fas fa-search"></span> Consultar </button>
            </div>
          </div> -->
        </div>
      </div>
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
    <?php include_once('../../modais.php'); ?>
  </main><!-- /.wrapper -->

  <script src="plugins/jquery/jquery.min.js?versao=3.2511.19.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.2511.19.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.2511.19.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.2511.19.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.2511.19.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.2511.19.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.2511.19.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.2511.19.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.2511.19.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.2511.19.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.2511.19.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.2511.19.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.2511.19.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.2511.19.1"></script>
  <script src="dist/js/sisplan.js?versao=3.2511.19.1"></script>
  <script src="utils/funcoes.js?versao=3.2511.19.1"></script>
  <script src="utils/cookies.js?versao=3.2511.19.1"></script>
  <script src="dist/js/driver.min.js?versao=3.2511.19.1"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.2511.19.1"></script>
  <script src="config.js?versao=3.2511.19.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELMOVIMENTACAO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relmovimentacao/relmovimentacao.js?versao=3.2511.19.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      // nomeTela


      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>